



/*
 *	Rlogin Source file 
 *	[Remote Login Client system]
 */

#include <netdb.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <termio.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>

#define SERVER_TCP_PORT 3001
#define BUFFSIZE 512

struct termio cli_termio;

struct termio tty_mode;

void pass_all(int fd);

int writen(int fd, char *ptr, int nbytes);

void err_sys(char *msg);

int tty_raw(int	fd);

int tty_reset(int fd);

int tty_getmode(int fd, struct termio *tty_termio);

int main(int argc, char **argv)
{
	int sd, port;
	struct hostent *hp;
	struct sockaddr_in server;
	char *host;

	switch (argc)
	{
		case 2 : host = argv[1];
			 port = SERVER_TCP_PORT;
			 break;
		case 3 : host = argv[1];
			 port = atoi(argv[2]);
			 break;
		default : fprintf(stderr, "Usage : %s host [port]\n", argv[0]);
			  exit(1);
	}

	/* create a stream socket */
	if ((sd = socket(AF_INET, SOCK_STREAM, 0)) == -1)
	{
		fprintf(stderr, "Can't create a socket\n");
		exit(1);
	}

	bzero((char *)&server, sizeof(struct sockaddr_in));
	server.sin_family = AF_INET;
	server.sin_port = htons(port);
	if ((hp = gethostbyname(host)) == NULL)
	{
		fprintf(stderr, "Can't get server address\n");
		exit(1);
	}

	bcopy(hp -> h_addr, (char *)&server.sin_addr, hp -> h_length);

	/* connecting to the server */
	if (connect(sd, (struct sockaddr *)&server, sizeof(server)) == -1)
	{
		fprintf(stderr, "Can't connect\n");
		exit(1);
	}

	printf("Connected : server address is %s\n", hp -> h_name);
	printf("Host name %s\n", hp -> h_name);


	/* read the current term mode */
	if (tty_getmode(0, &cli_termio) < 0)
		err_sys("Error while getting client terminal mode");

	/* send client termio to server rec process */
	if (write(sd, &cli_termio, sizeof(cli_termio)) < 0)
	        err_sys("Error while sending client termio");


	/* set input to raw mode */
	if (tty_raw(0) < 0)
		err_sys("tty_raw error");

	pass_all(sd);

	/* reset input back to normal */
	if (tty_reset(0) < 0)
		err_sys("tty_reset error");

	close(sd);
	return 0;
}


void pass_all(int fd)
{
	int maxfdp1, nfound, nread;
	char buff[BUFFSIZE];
	fd_set readmask;
	
	FD_ZERO(&readmask);
	
	for ( ; ; )
	{
		FD_SET(0, &readmask);
		FD_SET(fd, &readmask);
		maxfdp1 = fd + 1;
		
		nfound = select(maxfdp1, &readmask, (fd_set *) 0, (fd_set *) 0, (struct timeval *) 0);
		
		if (nfound < 0)
			err_sys("select error");
			
		if (FD_ISSET(0, &readmask))
		{
			nread = read(0, buff, BUFFSIZE);
			if (nread < 0)
				err_sys("read error from stdin");
			else if (nread == 0)
				break;
				
			if (write(fd, buff, nread) != nread)
				err_sys("writen error to stream pipe");
		}
		
		if (FD_ISSET(fd, &readmask))
		{
			nread = read(fd, buff, BUFFSIZE);
			if (nread <= 0)
				break;
				
			if (write(1, buff, nread) != nread)
				err_sys("write error to stdout");
		}
	}
}

int writen(int fd, char *ptr, int nbytes)
{
	int nleft, nwritten;
	
	nleft = nbytes;
	while (nleft > 0)
	{
		nwritten = write(fd, ptr, nleft);
		if (nwritten <= 0)
			return(nwritten);
			
		nleft -= nwritten;
		ptr += nwritten;
	}
	return(nbytes - nleft);
}

void err_sys(char *msg)
{
	fprintf(stderr, msg);
	fprintf(stderr, "\n");
	
	exit(1);
}

/*
 * Put a terminal device into RAW mode with ECHO off.
 * Before doing so we first save the terminal's current mode,
 * assuming the caller will call the tty_reset() function
 * (also in this file) when it's done with raw mode.
 */

int tty_raw(int	fd)		/* of terminal device */
{
	struct termio	temp_mode;

	if (ioctl(fd, TCGETA, (char *) &temp_mode) < 0)
		return(-1);
	tty_mode = temp_mode;		/* save for restoring later */

	temp_mode.c_iflag  = 0;		/* turn off all input control */
	temp_mode.c_oflag &= ~OPOST;	/* disable output post-processing */
	temp_mode.c_lflag &= ~(ISIG | ICANON | ECHO | XCASE);
					/* disable signal generation */
 					/* disable canonical input */
					/* disable echo */
					/* disable upper/lower output */
	temp_mode.c_cflag &= ~(CSIZE | PARENB);
					/* clear char size, disable parity */
	temp_mode.c_cflag |= CS8;	/* 8-bit chars */

	temp_mode.c_cc[VMIN]  = 1;	/* min #chars to satisfy read */
	temp_mode.c_cc[VTIME] = 1;	/* 10'ths of seconds between chars */

	if (ioctl(fd, TCSETA, (char *) &temp_mode) < 0)
		return(-1);

	return(0);
}

/*
 * Restore a terminal's mode to whatever it was on the most
 * recent call to the tty_raw() function above.
 */

int tty_reset(int fd)		/* of terminal device */
{
	if (ioctl(fd, TCSETA, (char *) &tty_mode) < 0)
		return(-1);

	return(0);
}


/*
 * Get a copy of the tty modes for a given file descriptor.
 * The copy is then used later by tty_setmode() below.
 */

int tty_getmode(int fd, struct termio *tty_termio)
{
	if (ioctl(fd, TCGETA, (char *) tty_termio) < 0)
		return(-1);

	return(0);
}


/*
 * Set the tty modes for a given file descriptor.
 * We set the modes from the values saved by tty_getmode() above.
 */

int tty_setmode(int fd, struct termio *tty_termio)
{
	if (ioctl(fd, TCSETA, (char *) tty_termio) < 0)
		return(-1);

	return(0);
}




