/*
 *	R e m o t e   L o g i n
 *
 *	Server Source File
 */
 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <termio.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>

#define SERVER_TCP_PORT 3001
#define BUFFSIZE 512

static char pty_name[12];


/*
 *	Function prototypes
 */

void rec_process(int csd, char **argv, char **envp);

void exec_shell(int fd, char **argv, char **envp);

void err_sys(char *msg);

int pty_master();

int pty_slave(int master_fd);

void pass_all(int fd);

int tty_setmode(int fd, struct termio *tty_termio);


int main(int argc, char **argv, char **envp)
{
	int sd, new_sd, client_len, port;
	pid_t pid, childpid;
	int tt =1 ;

	struct sockaddr_in server, client;

	if ((pid = fork()) < 0)
	{
		err_sys("Fork error");
		return(-1);
	}
	else if (pid != 0)
		exit(0);	/* parent goes bye-bye */

	/* the child of the server continues */

	setsid();	/* become session leader */
	
	/* assign port */
	switch (argc--)
	{
		case 1 : port = SERVER_TCP_PORT;
			 break;
		case 2 : printf("%d\n",(port = atoi(argv[1])));
			 break;
		default : fprintf(stderr, "Usage : %s [port]\n", argv[0]);
			  exit(1);
	}

	/* create a stream socket */
	if ((sd = socket(AF_INET, SOCK_STREAM, 0)) == -1)
	{
		fprintf(stderr, "Can't create a socket\n");
		exit(1);
	}

	/* bind an address to the socket */
	bzero((char *) &server, sizeof(struct sockaddr_in));
	server.sin_family = AF_INET;
	server.sin_port = htons(port);
	server.sin_addr.s_addr = htonl(INADDR_ANY);
	printf("port=%d\n",port);
	if((setsockopt ( sd , SOL_SOCKET ,SO_REUSEADDR , &tt , sizeof(tt) ))<0)
	       printf("some problem in sock _optin\n");
	if ((bind(sd, (struct sockaddr *)&server, sizeof(server))) < 0)
	{
		fprintf(stderr, "Can't bind name to socket\n");
		exit(1);
	}

	/* queue upto 5 connect requests */
	listen(sd, 5);

	while (1)
	{	printf("serverr waitin\n");
		
		/*
		 * Wait for a connection from a client process
		 */
		
		client_len = sizeof(client);
		if ((new_sd = accept(sd, (struct sockaddr *)&client, &client_len)) == -1)
		{
			fprintf(stderr, "Parent of me is : %d\n", getppid());
			fprintf(stderr, "Can't accept client\n");
			exit(1);
		}
		
		if ((childpid = fork()) < 0)
			err_sys("server : fork error");
		else if (childpid == 0)	/* server forks here */
		{
			close(sd);

			rec_process(new_sd, argv, envp);
			
			/* everythings over in rec-process so wind up */
			exit(0);
		}
		
		close(new_sd);
			
	}

	close(sd);
	return 0;
}


/*
 * The recording process and the shell
 */

void rec_process(int csd, char **argv, char **envp)
{
        int master_fd, slave_fd;
	pid_t shellchildpid;
	struct termio cli_termio;

        /* rec process starts here */
	if (!isatty(0) || !isatty(1))
		err_sys("stdin and stdout must be a terminal");

	master_fd = pty_master();

	if (master_fd < 0)
		err_sys("can't open master pty");

        if (read(csd, &cli_termio, sizeof(cli_termio)) < 0)
	        err_sys("Error while reading client termio");
		
	if ((shellchildpid = fork()) < 0)
		err_sys("can't fork");
	else if (shellchildpid == 0)	/* the child shell starts */
	{
		slave_fd = pty_slave(master_fd);
		if (slave_fd < 0)
			err_sys("can't open pty slave");
		close(master_fd);

		if (tty_setmode(slave_fd, &cli_termio) < 0)
			err_sys("can't set tty mode of pty slave");
		
		exec_shell(slave_fd, argv, envp);
		/* NOT REACHED */
	}
	
	/* rec process continues */
	
	close(0);
	close(1);
	
	if (dup(csd) != 0 || dup(csd) != 1)
		err_sys("Couldn't connect 0 & 1 to socket");

	pass_all(master_fd);
}


void exec_shell(int fd, char **argv, char **envp)
{
	close(0);
	close(1);
	close(2);
	
	if (dup(fd) != 0 || dup(fd) != 1 || dup(fd) != 2)
		err_sys("dup error");
	close(fd);
	
	/* exec the shell */
/*	execve(shell, argv, envp);*/
	execl("/bin/login", "-p", (char *)0);
	err_sys("execve error");
	/* Not Reached */
}

void err_sys(char *msg)
{
	fprintf(stderr, msg);
	fprintf(stderr, "\n");
	
	exit(1);
}
	

int pty_master()
{
	int i, master_fd;
	char *ptr;
	static struct stat statbuff;
	static char ptychar[] = "abcdefghijklmnopqrs";
	static char hexdigit[] = "0123456789abcdef";
	
	/* Try all possible names until opening a master half */
	
	for (ptr = ptychar; *ptr != 0; ptr++)
	{
		strcpy(pty_name, "/dev/ptyXY");
		pty_name[8] = *ptr;
		pty_name[9] = '0';
		
		if (stat(pty_name, &statbuff) < 0)
			break;
			
		for (i = 0; i < 16; i++)
		{
			pty_name[9] = hexdigit[i];
			if ((master_fd = open(pty_name, O_RDWR)) >= 0)
				return(master_fd);
		}
	}
	return(-1);
}


/* Open slave half of pseudo terminal */

int pty_slave(int master_fd)
{
	int slave_fd;
	
	pty_name[5] = 't';
	if ((slave_fd = open(pty_name, O_RDWR)) < 0)
	{
		close(master_fd);
		return(-1);
	}
	
	return(slave_fd);
}

void pass_all(int fd)
{
	int maxfdp1, nfound, nread;
	char buff[BUFFSIZE];
	fd_set readmask;
	
	FD_ZERO(&readmask);
	
	for ( ; ; )
	{
		FD_SET(0, &readmask);
		FD_SET(fd, &readmask);
		maxfdp1 = fd + 1;
		
		nfound = select(maxfdp1, &readmask, (fd_set *) 0, (fd_set *) 0, (struct timeval *) 0);
		
		if (nfound < 0)
			err_sys("select error");
			
		if (FD_ISSET(0, &readmask))
		{
			nread = read(0, buff, BUFFSIZE);
			if (nread < 0)
				err_sys("read error from stdin");
			else if (nread == 0)
				break;
				
			if (write(fd, buff, nread) != nread)
				err_sys("writen error to stream pipe");
		}
		
		if (FD_ISSET(fd, &readmask))
		{
			nread = read(fd, buff, BUFFSIZE);
			if (nread <= 0)
				break;
				
			if (write(1, buff, nread) != nread)
				err_sys("write error to stdout");
		}
	}
}


/*
 * Set the tty modes for a given file descriptor.
 * We set the modes from the values saved by tty_getmode() above.
 */

int tty_setmode(int fd, struct termio *tty_termio)
{
	if (ioctl(fd, TCSETA, (char *) tty_termio) < 0)
		return(-1);

	return(0);
}



